/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    AppSmarTag.h
  * @author  System Research & Applications Team - Catania & Agrate Lab.
  * @version 1.1.0
  * @date    22-February-2023
  * @brief   Header for AppSmarTag.c file.
  *          This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __APP_SMARTAG_H
#define __APP_SMARTAG_H

#include "SmartNFCType.h"

#ifdef __cplusplus
extern "C" {
#endif

// formulas to convert sample values to coded for storage moved by Gerrans
#define STTS22H_SAMPLE_TO_CODED(Value)       ((uint16_t)(((Value)*5) - ((-10)*5)))
#define LPS22DF_SAMPLE_TO_CODED(Value)       ((uint16_t)(((Value)*2) - ((260)*2)))
#define VD6283_LUX_SAMPLE_TO_CODED(Value)    ((uint32_t)((Value)*1000))
//additional formulas for added SHT4x sensor
#define SHT40_TEMP_SAMPLE_TO_CODED(Value)	 ((uint16_t)(((Value)*5) - ((-40)*5)))
#define SHT40_HUM_SAMPLE_TO_CODED(Value)	 ((uint8_t)((Value)*2))

// formulas to convert sample values to readable for printing
#define STTS22H_CODED_TO_SAMPLE(Value)       ((((float)(Value))/5)-10)
#define LPS22DF_CODED_TO_SAMPLE(Value)       ((((float)(Value))/2)+260)
#define VD6283_LUX_CODED_TO_SAMPLE(Value)    (((float)(Value))/1000)
//additional formulas for added SHT4x sensor
#define SHT40_TEMP_CODED_TO_SAMPLE(Value)	 ((((float)(Value))/5)-40)
#define SHT40_HUM_CODED_TO_SAMPLE(Value)	 (((float)(Value))/2)

//ST Smart NFC Protocol moved by gerrans
extern SNFC_CodeDefinition_t SmarTag2CodeHeader;
extern SNFC_LogDefinition_t LogDefinition;
extern SNFC_VirtualSensor_t AllVirtualSensorsArray[SMARTAG2_VIRTUAL_SENSORS_NUM];
extern SNFC_VirtualSensor_t* ConfiguratedVirtualSensorsArray[SMARTAG2_VIRTUAL_SENSORS_NUM];

typedef enum{
	TagScanning =0,
	TagInactive

}NFCStatus_t;


typedef enum//storage locations for environmental data
{
	NFC =0,
	Flash
}memStore_t;

struct staticInfo{// global static medicine information
	char medType[50];
	char medBrand[50];
	int dosage ; // medicine dosage in mg.
	int quantity; // number of doses in package
	uint32_t expiry;
};
extern int stopTest;
extern memStore_t boardMem;
extern NFCStatus_t TagStatus;
extern struct staticInfo medInfo;// global medicine info

extern void SmarTagAppStart(void);
extern void SmarTagAppWakeUpTimerCallBack(void);
extern void SmarTagAppProcess(void);
extern void SmarTagAppDetectMemsEvent(void);
extern void SmarTagAppDetectRFActivity(void);
extern void ReadCommand(void);
extern void printDateTime(void);
extern void ScanningLoop(void);
extern void UpdateLastSamplePointerAndSampleCounter(SNFC_LogDefinition_t *LogDefinition);
#ifdef __cplusplus
}
#endif

#endif /* __APP_SMARTAG_H */
